﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Items : RPGByteData
    {
        List<Item> items;
        
        public Items(FileStream f)
        {
            load(f);
        }
        public Items()
        {
        }
        
        override public void load(FileStream f)
        {
            items = M.readDatabaseList<Item>(f, "Items", "Item", ref M.itemNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Item>(items);
        }
    }
    
    class Item : RPGDatabaseEntry
    {
        int id = 0;
        string itemName = ""; // 01
        string itemDescription = ""; // 02
        int classification = 0; // 03
        int price = 0; // 05
        int useCount = 1; // 06
        int atkStat = 0; // 0b
        int defStat = 0; // 0c
        int mindStat = 0; // 0d
        int agiStat = 0; // 0e
        bool twoHanded = false; // 0f
        int mpCost = 0; // 10
        int hitChance = 90; // 11
        int critChance = 0; // 12
        int animationID = 1; // 14
        bool preemptive = false; // 15
        bool attackTwice = false; // 16
        bool attackAll = false; // 17
        bool ignoreEvasion = false; // 18
        bool preventCrit = false; // 19
        bool increaseEvasion = false; // 1a
        bool halfMPCost = false; // 1b
        bool noTerrainDamage = false; // 1c
        bool cursed = false; // 1d (2003)
        bool targetEntireParty = false; // 1f
        int recoverHPPercent = 0; // 20
        int recoverHPPlus = 0; // 21
        int recoverMPPercent = 0; // 22
        int recoverMPPlus = 0; // 23
        bool onlyFromMenu = false; // 25
        bool onlyIfFainted = false; // 26
        int maxHPChange = 0; // 29
        int mapMPChange = 0; // 2a
        int atkChange = 0; // 2b
        int defChange = 0; // 2c
        int mindChange = 0; // 2d
        int agiChange = 0; // 2e
        int useMessageType = 0; // 33
        int invokeSkillNum = 1; // 35
        int invokeSwitchNum = 1; // 37
        bool onField = true; // 39
        bool inBattle = false; // 3a
        int heroListLength; // 3d
        bool[] heroList; // 3e
        int conditionListLength; // 3f
        bool[] conditionList; // 40
        int attributeListLength; // 41
        bool[] attributeList; // 42
        int conditionChance = 0; // 43
        bool conditionRemove = false; // 44 (2003)
        int weaponAnimation = 1; // 45 (2003)
        List<ItemAnimationData> animationData; // 46 (2003)
        bool useSkill = false; // 47 (2003)
        int classListLength; // 48 (2003)
        bool[] classList; // 49 (2003)
        int rangedTrajectory = 0; // 4b (2003)
        int rangedTarget = 0; // 4c (2003)
        
        static string myClass = "Item";
        Chunks chunks;
        
        public Item(FileStream f)
        {
            load(f);
        }
        public Item()
        {
        }
        
        public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                itemName = M.readStringDataName(f, id, ref M.itemNames, M.S_TOTRANSLATE);
            
            if (chunks.next(0x02))
                itemDescription = M.readString(f, M.S_TOTRANSLATE);
            if (chunks.next(0x03))
                classification = M.readLengthMultibyte(f);
            
            if (chunks.next(0x05))
                price = M.readLengthMultibyte(f);
            if (chunks.next(0x06))
                useCount = M.readLengthMultibyte(f);
            
            if (chunks.next(0x0b))
                atkStat = M.readLengthMultibyte(f);
            if (chunks.next(0x0c))
                defStat = M.readLengthMultibyte(f);
            if (chunks.next(0x0d))
                mindStat = M.readLengthMultibyte(f);
            if (chunks.next(0x0e))
                agiStat = M.readLengthMultibyte(f);
            if (chunks.next(0x0f))
                twoHanded = M.readLengthBool(f);
            if (chunks.next(0x10))
                mpCost = M.readLengthMultibyte(f);
            if (chunks.next(0x11))
                hitChance = M.readLengthMultibyte(f);
            if (chunks.next(0x12))
                critChance = M.readLengthMultibyte(f);
            
            if (chunks.next(0x14))
                animationID = M.readLengthMultibyte(f);
            if (chunks.next(0x15))
                preemptive = M.readLengthBool(f);
            if (chunks.next(0x16))
                attackTwice = M.readLengthBool(f);
            if (chunks.next(0x17))
                attackAll = M.readLengthBool(f);
            if (chunks.next(0x18))
                ignoreEvasion = M.readLengthBool(f);
            if (chunks.next(0x19))
                preventCrit = M.readLengthBool(f);
            if (chunks.next(0x1a))
                increaseEvasion = M.readLengthBool(f);
            if (chunks.next(0x1b))
                halfMPCost = M.readLengthBool(f);
            if (chunks.next(0x1c))
                noTerrainDamage = M.readLengthBool(f);
            if (chunks.next(0x1d))
                cursed = M.readLengthBool(f);
            
            if (chunks.next(0x1f))
                targetEntireParty = M.readLengthBool(f);
            if (chunks.next(0x20))
                recoverHPPercent = M.readLengthMultibyte(f);
            if (chunks.next(0x21))
                recoverHPPlus = M.readLengthMultibyte(f);
            if (chunks.next(0x22))
                recoverMPPercent = M.readLengthMultibyte(f);
            if (chunks.next(0x23))
                recoverMPPlus = M.readLengthMultibyte(f);
            
            if (chunks.next(0x25))
                onlyFromMenu = M.readLengthBool(f);
            if (chunks.next(0x26))
                onlyIfFainted = M.readLengthBool(f);
            
            if (chunks.next(0x29))
                maxHPChange = M.readLengthMultibyte(f);
            if (chunks.next(0x2a))
                mapMPChange = M.readLengthMultibyte(f);
            if (chunks.next(0x2b))
                atkChange = M.readLengthMultibyte(f);
            if (chunks.next(0x2c))
                defChange = M.readLengthMultibyte(f);
            if (chunks.next(0x2d))
                mindChange = M.readLengthMultibyte(f);
            if (chunks.next(0x2e))
                agiChange = M.readLengthMultibyte(f);
            
            if (chunks.next(0x33))
                useMessageType = M.readLengthMultibyte(f);
            
            if (chunks.next(0x35))
                invokeSkillNum = M.readLengthMultibyte(f);
            
            if (chunks.next(0x37))
                invokeSwitchNum = M.readLengthMultibyte(f);
            
            if (chunks.next(0x39))
                onField = M.readLengthBool(f);
            if (chunks.next(0x3a))
                inBattle = M.readLengthBool(f);
            
            if (chunks.next(0x3d))
                heroListLength = M.readLengthMultibyte(f);
            if (chunks.next(0x3e))
                heroList = M.readBoolArray(f);
            
            if (chunks.next(0x3f))
                conditionListLength = M.readLengthMultibyte(f);
            if (chunks.next(0x40))
                conditionList = M.readBoolArray(f);
            
            if (chunks.next(0x41))
                attributeListLength = M.readLengthMultibyte(f);
            if (chunks.next(0x42))
                attributeList = M.readBoolArray(f);
            
            if (chunks.next(0x43))
                conditionChance = M.readLengthMultibyte(f);
            if (chunks.next(0x44))
                conditionRemove = M.readLengthBool(f);
            
            if (chunks.next(0x45))
                weaponAnimation = M.readLengthMultibyte(f);
            if (chunks.next(0x46))
                animationData = M.readList<ItemAnimationData>(f);
            
            if (chunks.next(0x47))
                useSkill = M.readLengthBool(f);
            if (chunks.next(0x48))
                classListLength = M.readLengthMultibyte(f);
            
            if (chunks.next(0x49))
                classList = M.readBoolArray(f);
            
            if (chunks.next(0x4b))
                rangedTrajectory = M.readLengthMultibyte(f);
            if (chunks.next(0x4c))
                rangedTarget = M.readLengthMultibyte(f);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeString(itemName, M.S_TOTRANSLATE);
            
            if (chunks.wasNext(0x02))
                M.writeString(itemDescription, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x03))
                M.writeLengthMultibyte(classification);
            
            if (chunks.wasNext(0x05))
                M.writeLengthMultibyte(price);
            if (chunks.wasNext(0x06))
                M.writeLengthMultibyte(useCount);
            
            if (chunks.wasNext(0x0b))
                M.writeLengthMultibyte(atkStat);
            if (chunks.wasNext(0x0c))
                M.writeLengthMultibyte(defStat);
            if (chunks.wasNext(0x0d))
                M.writeLengthMultibyte(mindStat);
            if (chunks.wasNext(0x0e))
                M.writeLengthMultibyte(agiStat);
            if (chunks.wasNext(0x0f))
                M.writeLengthBool(twoHanded);
            if (chunks.wasNext(0x10))
                M.writeLengthMultibyte(mpCost);
            if (chunks.wasNext(0x11))
                M.writeLengthMultibyte(hitChance);
            if (chunks.wasNext(0x12))
                M.writeLengthMultibyte(critChance);
            
            if (chunks.wasNext(0x14))
                M.writeLengthMultibyte(animationID);
            if (chunks.wasNext(0x15))
                M.writeLengthBool(preemptive);
            if (chunks.wasNext(0x16))
                M.writeLengthBool(attackTwice);
            if (chunks.wasNext(0x17))
                M.writeLengthBool(attackAll);
            if (chunks.wasNext(0x18))
                M.writeLengthBool(ignoreEvasion);
            if (chunks.wasNext(0x19))
                M.writeLengthBool(preventCrit);
            if (chunks.wasNext(0x1a))
                M.writeLengthBool(increaseEvasion);
            if (chunks.wasNext(0x1b))
                M.writeLengthBool(halfMPCost);
            if (chunks.wasNext(0x1c))
                M.writeLengthBool(noTerrainDamage);
            if (chunks.wasNext(0x1d))
                M.writeLengthBool(cursed);
            
            if (chunks.wasNext(0x1f))
                M.writeLengthBool(targetEntireParty);
            if (chunks.wasNext(0x20))
                M.writeLengthMultibyte(recoverHPPercent);
            if (chunks.wasNext(0x21))
                M.writeLengthMultibyte(recoverHPPlus);
            if (chunks.wasNext(0x22))
                M.writeLengthMultibyte(recoverMPPercent);
            if (chunks.wasNext(0x23))
                M.writeLengthMultibyte(recoverMPPlus);
            
            if (chunks.wasNext(0x25))
                M.writeLengthBool(onlyFromMenu);
            if (chunks.wasNext(0x26))
                M.writeLengthBool(onlyIfFainted);
            
            if (chunks.wasNext(0x29))
                M.writeLengthMultibyte(maxHPChange);
            if (chunks.wasNext(0x2a))
                M.writeLengthMultibyte(mapMPChange);
            if (chunks.wasNext(0x2b))
                M.writeLengthMultibyte(atkChange);
            if (chunks.wasNext(0x2c))
                M.writeLengthMultibyte(defChange);
            if (chunks.wasNext(0x2d))
                M.writeLengthMultibyte(mindChange);
            if (chunks.wasNext(0x2e))
                M.writeLengthMultibyte(agiChange);
            
            if (chunks.wasNext(0x33))
                M.writeLengthMultibyte(useMessageType);
            
            if (chunks.wasNext(0x35))
                M.writeLengthMultibyte(invokeSkillNum);
            
            if (chunks.wasNext(0x37))
                M.writeLengthMultibyte(invokeSwitchNum);
            
            if (chunks.wasNext(0x39))
                M.writeLengthBool(onField);
            if (chunks.wasNext(0x3a))
                M.writeLengthBool(inBattle);
            
            if (chunks.wasNext(0x3d))
                M.writeLengthMultibyte(heroListLength);
            if (chunks.wasNext(0x3e))
                M.writeBoolArray(heroList);
            
            if (chunks.wasNext(0x3f))
                M.writeLengthMultibyte(conditionListLength);
            if (chunks.wasNext(0x40))
                M.writeBoolArray(conditionList);
            
            if (chunks.wasNext(0x41))
                M.writeLengthMultibyte(attributeListLength);
            if (chunks.wasNext(0x42))
                M.writeBoolArray(attributeList);
            
            if (chunks.wasNext(0x43))
                M.writeLengthMultibyte(conditionChance);
            if (chunks.wasNext(0x44))
                M.writeLengthBool(conditionRemove);
            
            if (chunks.wasNext(0x45))
                M.writeLengthMultibyte(weaponAnimation);
            if (chunks.wasNext(0x46))
                M.writeList<ItemAnimationData>(animationData);
            
            if (chunks.wasNext(0x47))
                M.writeLengthBool(useSkill);
            if (chunks.wasNext(0x48))
                M.writeLengthMultibyte(classListLength);
            
            if (chunks.wasNext(0x49))
                M.writeBoolArray(classList);
            
            if (chunks.wasNext(0x4b))
                M.writeLengthMultibyte(rangedTrajectory);
            if (chunks.wasNext(0x4c))
                M.writeLengthMultibyte(rangedTarget);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            // Since the default item type is Common Goods, only fields applicable to those need to be checked. Phew.
            if (itemName != "" // 01
             || itemDescription != "" // 02
             || classification != 0 // 03
             || price != 0) // 05
                return false;
            
            return true;
        }
    }
    
    class ItemAnimationData : RPGByteData
    {
        int id = 0;
        int type = 0; // 03
        int weaponAnimation = 0; // 04
        int movement = 0; // 05
        int afterimages = 0; // 06
        int attackCount = 0; // 07
        bool ranged = false; // 08
        int rangedAnimation = 0; // 09
        int rangedAnimationSpeed = 0; // 0c
        int battleAnimation = 0; // 0d
        int pose = 4; // 0e
        
        static string myClass = "ItemAnimationData";
        Chunks chunks;
        
        public ItemAnimationData(FileStream f)
        {
            load(f);
        }
        public ItemAnimationData()
        {
        }
        
        override public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x03))
                type = M.readLengthMultibyte(f);
            if (chunks.next(0x04))
                weaponAnimation = M.readLengthMultibyte(f);
            if (chunks.next(0x05))
                movement = M.readLengthMultibyte(f);
            if (chunks.next(0x06))
                afterimages = M.readLengthMultibyte(f);
            if (chunks.next(0x07))
                attackCount = M.readLengthMultibyte(f);
            if (chunks.next(0x08))
                ranged = M.readLengthBool(f);
            if (chunks.next(0x09))
                rangedAnimation = M.readLengthMultibyte(f);
            if (chunks.next(0x0c))
                rangedAnimationSpeed = M.readLengthMultibyte(f);
            if (chunks.next(0x0d))
                battleAnimation = M.readLengthMultibyte(f);
            if (chunks.next(0x0e))
                pose = M.readLengthMultibyte(f);
            
            M.byteCheck(f, 0x00);
        }
        
        override protected void myWrite()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x03))
                M.writeLengthMultibyte(type);
            if (chunks.wasNext(0x04))
                M.writeLengthMultibyte(weaponAnimation);
            if (chunks.wasNext(0x05))
                M.writeLengthMultibyte(movement);
            if (chunks.wasNext(0x06))
                M.writeLengthMultibyte(afterimages);
            if (chunks.wasNext(0x07))
                M.writeLengthMultibyte(attackCount);
            if (chunks.wasNext(0x08))
                M.writeLengthBool(ranged);
            if (chunks.wasNext(0x09))
                M.writeLengthMultibyte(rangedAnimation);
            if (chunks.wasNext(0x0c))
                M.writeLengthMultibyte(rangedAnimationSpeed);
            if (chunks.wasNext(0x0d))
                M.writeLengthMultibyte(battleAnimation);
            if (chunks.wasNext(0x0e))
                M.writeLengthMultibyte(pose);
            
            M.writeByte(0x00);
        }
    }
}
